local assets=
{
    Asset("ANIM", "anim/shadowheart.zip"),
    Asset("ATLAS", "images/inventoryimages/shadowheart.xml"),
    Asset("IMAGE", "images/inventoryimages/shadowheart.tex"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBuild("shadowheart")
	inst.AnimState:SetBank("shadowheart")
	inst.AnimState:PlayAnimation("idle")
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue =  200
	inst.components.edible.hungervalue =  300
	inst.components.edible.sanityvalue =  -25
	
	inst:AddComponent("inspectable")
	
	inst:AddComponent("tradable")
	
	inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "shadowheart"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/shadowheart.xml"
	return inst
end

STRINGS.NAMES.SHADOWHEART = "Shadow Atrium"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SHADOWHEART =  "The dark, the light, where is the difference?"

return Prefab( "common/inventory/shadowheart", fn, assets)